package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.skills.CharacteristicChoice;
import com.hero.objects.talents.SimulateDeath;
import com.hero.util.Constants;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class SimulateDeathDialog extends GenericDialog {
	private static final long serialVersionUID = -1326481373953609021L;

	protected SimulateDeath skill;

	private JLabel characteristicLbl;

	private JLabel rollLbl;

	private JComboBox characteristicCombo;

	public SimulateDeathDialog(SimulateDeath skill, boolean isNew,
			boolean isPower) {
		super(skill, isNew, isPower);
		this.skill = skill;
		init();
		if (pointsLbl != null) {
			pointsLbl.setVisible(false);
		}
		if (pointsTF != null) {
			pointsTF.setVisible(false);
		}
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 50;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(5, 5, 5, 5);
		if ((skill.getCharacteristicChoices() != null)
				&& (skill.getCharacteristicChoices().size() > 0)) {
			panel.add(characteristicLbl, gbc);
		}
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		if ((skill.getCharacteristicChoices() != null)
				&& (skill.getCharacteristicChoices().size() > 0)) {
			if (skill.getCharacteristicChoices().size() == 1) {
				CharacteristicChoice choice = skill.getCharacteristicChoices()
						.get(0);
				if (choice.getBaseCost() >= 0) {
					skill.setBaseCost(choice.getBaseCost());
				}
				skill.setCharacteristic(choice.getCharacteristic());
				if (choice.getLevelCost() >= 0) {
					skill.setLevelCost(choice.getLevelCost());
				}
				if (choice.getLevelValue() >= 0) {
					skill.setLevelValue(choice.getLevelValue());
				}
				if (choice.getMinimumCost() > -999) {
					skill.setMinimumCost(choice.getMinimumCost());
				}
				if (choice.getMinimumLevel() >= 0) {
					skill.setMinimumLevel(choice.getMinimumLevel());
				}
				updateValues();
				panel.add(new JLabel(Constants.getCharacteristicString(choice
						.getCharacteristic())), gbc);
			} else {
				panel.add(characteristicCombo, gbc);
			}
		}
		gbc.gridy = 70;
		gbc.gridx = 2;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		if (skill.getRoll().trim().length() > 0) {
			panel.add(rollLbl, gbc);
		}
		gbc.gridy = 80;
		gbc.gridx = 1;
		gbc.weightx = 1;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weighty = 0;
		gbc.weightx = 0;
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		characteristicCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				updateValues();
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		characteristicLbl = new JLabel("Characteristic:");
		rollLbl = new JLabel("Roll:");
		characteristicCombo = new JComboBox(skill.getCharacteristicChoices()
				.toArray());
		levelTF.setEnabled(true);
		levelsLbl.setEnabled(true);

		// initialize from the characteristic choice....
		if ((skill.getCharacteristicChoices() != null)
				&& (skill.getCharacteristicChoices().size() > 0)) {
			if (skill.getCharacteristicChoices().size() == 1) {
				CharacteristicChoice choice = skill.getCharacteristicChoices()
						.get(0);
				if (choice.getBaseCost() >= 0) {
					skill.setBaseCost(choice.getBaseCost());
				}
				skill.setCharacteristic(choice.getCharacteristic());
				if (choice.getLevelCost() >= 0) {
					skill.setLevelCost(choice.getLevelCost());
				}
				if (choice.getLevelValue() >= 0) {
					skill.setLevelValue(choice.getLevelValue());
				}
				if (choice.getMinimumCost() > -999) {
					skill.setMinimumCost(choice.getMinimumCost());
				}
				if (choice.getMinimumLevel() >= 0) {
					skill.setMinimumLevel(choice.getMinimumLevel());
				}
				updateValues();
			} else {
				for (int i = 0; i < skill.getCharacteristicChoices().size(); i++) {
					CharacteristicChoice choice = skill
							.getCharacteristicChoices().get(i);
					if (choice.getCharacteristic() == skill.getCharacteristic()) {
						characteristicCombo.setSelectedIndex(i);
						break;
					}
				}
				updateValues();
			}
		}
	}

	@Override
	public void updateValues() {
		CharacteristicChoice choice = (CharacteristicChoice) characteristicCombo
				.getSelectedItem();
		if (choice != null) {
			skill.setCharacteristic(choice.getCharacteristic());
		}
		rollLbl.setText(skill.getRoll());
		super.updateValues();
	}
}